#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

#include "dolgozat.h"
#include "hasonlosag.h"



/* Beolvassa a megadott nevű vezérlőfájlt, és felépíti
 * a listát, amelyben a dolgozatok vannak. Igazzal tér vissza,
 * ha minden rendben volt. */
static bool vezerlofajl_beolvas(char *vezerlofajl, Dolgozat **pdolgozatok)
{
    FILE *fp = fopen(vezerlofajl, "rt");
    if (fp == NULL) {
        fprintf(stderr, "Nem lehet megnyitni a vezerlofajlt: %s\n", vezerlofajl);
        return false;
    }

    *pdolgozatok = NULL;
    char fajlnev[33], nev[45];
    int ret;
    while ((ret = fscanf(fp, "%s %[^\n]", fajlnev, nev)) == 2) {
        Dolgozat *uj = uj_dolgozat(fajlnev, nev);
        uj->kov = *pdolgozatok;
        *pdolgozatok = uj;
    }
    fclose(fp);
    if (ret != EOF) {
        fprintf(stderr, "Hiba a vezerlofajl olvasasa kozben: %s\n", vezerlofajl);
        return false;
    }
    return true;
}


/* CSV formátumban kimeneti fájlba írja a teljes hasonlóság tömböt. */
static bool kimenetifajlt_ir(Hasonlosag *hasonlosagok, int has_db, char *kimenetifajl)
{
    FILE *fp = fopen(kimenetifajl, "wt");
    if (fp == NULL)
        return false;
    for (int i = 0; i < has_db; ++i)
        hasonlosag_fajlba(hasonlosagok[i], fp);
    fclose(fp);
    return true;
}


/* Főprogram */
int main(int argc, char **argv)
{
    if (argc < 2 || argc > 3) {
        printf("Plagiumdetektor\n\n"
               "Hasznalat: %s <vezerlofajl> [kimenetifajl]\n\n"
               "A vezerlofajl formatuma soronkent:\n"
               "  fajlnev szerzo_neve\n"
               "A fajlnev nem tartalmazhat szokozoket, a szerzo neve viszont igen.\n", argv[0]);
        return 3;
    }
    char *vezerlofajl = argv[1];
    char *kimenetifajl = argc >= 3 ? argv[2] : NULL;

    /* beolvasás */
    Dolgozat *dolgozatok;
    bool ok;
    ok = vezerlofajl_beolvas(vezerlofajl, &dolgozatok);
    if (!ok)
        return 1;
    ok = dolgozatok_beolvas(dolgozatok);
    if (!ok)
        return 2;

    /* feldolgozás */
    Hasonlosag *hasonlosagok;
    int has_db;
    hasonlosagok = hasonlit_osszes(dolgozatok, &has_db);
    hasonlosag_rendez(hasonlosagok, has_db);

    /* hasonlóságok a szabványos kimenetre */
    printf("\n20 legerosebb hasonlosag:\n");
    for (int i = 0; i < 20 && i < has_db; ++i)
        hasonlosag_kepernyore(hasonlosagok[i]);

    /* és ha kérte a felhasználó, fájlba */
    if (kimenetifajl != NULL) {
        ok = kimenetifajlt_ir(hasonlosagok, has_db, kimenetifajl);
        if (!ok) {
            fprintf(stderr, "Nem tudom megnyitni a kimeneti fajlt: %s\n", kimenetifajl);
            return 4;
        }
    }

    /* felszabadítások */
    free(hasonlosagok);
    dolgozatok_felszabadit(dolgozatok);

    return 0;
}
