#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#include "hasonlosag.h"
#include "szohalmaz.h"

/* Visszatér a két szám közül a kisebbikkel. */
static int min(int a, int b)
{
    return a < b ? a : b;
}

/* Összehasonlít két dolgozatot, és a hasonlítás
 * eredményével tér vissza (amely egy teljesen
 * kitöltött Hasonlóság struktúra.) */
static Hasonlosag hasonlit(Dolgozat *d1, Dolgozat *d2)
{
    Hasonlosag h;
    h.d1 = d1;
    h.d2 = d2;
    
    /* két hasonlóság közül a nagyobbik, azaz a kisebbik méretével osztjuk el. */
    int metszet = halmaz_metszet_meret(d1->kifejezesek, d2->kifejezesek);
    int kisebb = min(halmaz_meret(d1->kifejezesek), halmaz_meret(d2->kifejezesek));
    h.has = metszet / (double) kisebb;

    return h;
}


/* Végigmegy az összes dolgozaton, és páronként összehasonlítja őket.
 * Egy tömbbe beteszi az így kapott eredményeket, pontosan
 * n*(n-1) darabot, ahol n a dolgozatok lista mérete. Ezt a számot
 * be is írja a kapott int típusú változóba.
 * A visszaadott tömböt fel kell majd szabadítani a free() függvénnyel.
 * Az összehasonlítás nem szimmetrikus! Erről bővebben a részletes
 * dokumentációban. */
Hasonlosag *hasonlit_osszes(Dolgozat *dolgozatok, int *phas_db)
{
    int dolg_db = dolgozatok_meret(dolgozatok);
    int has_db = dolg_db * (dolg_db - 1) / 2;
    Hasonlosag *hasonlosagok = (Hasonlosag*) malloc(has_db * sizeof(Hasonlosag));

    int i = 0;
    for (Dolgozat *iter1 = dolgozatok; iter1 != NULL; iter1 = iter1->kov)
        for (Dolgozat *iter2 = iter1->kov; iter2 != NULL; iter2 = iter2->kov)
            hasonlosagok[i++] = hasonlit(iter1, iter2);

    *phas_db = has_db;
    return hasonlosagok;
}


/* Rendező függvény a qsort()-tal való használathoz.
 * A két dolgozat hasonlóságának átlaga szerint csökkenő sorrendbe. */
static int osszkep_szerint(void const *egyik, void const *masik)
{
    Hasonlosag const *h1 = (Hasonlosag const *) egyik;
    Hasonlosag const *h2 = (Hasonlosag const *) masik;
    if (h1->has < h2->has)
        return +1;
    if (h1->has > h2->has)
        return -1;
    return 0;
}


/* Csökkenő sorba rendezi a hasonlóságokat. */
void hasonlosag_rendez(Hasonlosag *hasonlosagok, int hasszam)
{
    qsort(hasonlosagok, hasszam, sizeof(hasonlosagok[0]), osszkep_szerint);
}


/* Képernyőre írja felhasználó által könnyen olvasható formában a hasonlóság
 * adatait: neveket, fájlneveket, hasonlóság %-át. */
void hasonlosag_kepernyore(Hasonlosag h)
{
    printf("%s (%s) <-> %s (%s), %.2f%%\n",
                   h.d1->nev, h.d1->fajlnev,
                   h.d2->nev, h.d2->fajlnev,
                   h.has * 100);
}


/* Fájlba írja egy hasonlóság adatait:
 * - mértékét,
 * - első nevet és fájlnevet,
 * - második nevet és fájlnevet,
 * pontosvesszővel elválasztva. */
void hasonlosag_fajlba(Hasonlosag h, FILE *fp)
{
    fprintf(fp, "%.2f;%s;%s;%s;%s\n", h.has * 100,
            h.d1->nev, h.d1->fajlnev,
            h.d2->nev, h.d2->fajlnev);
}
