#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <ctype.h>
#include <stdio.h>

#include "dolgozat.h"


/* Új dolgozatot hoz létre, a paraméterkent kapott
 * fájlnévvel és névvel.
 * A benne lévő szóhalmazokat egyelőre üresre állítja. */
Dolgozat *uj_dolgozat(char *fajlnev, char *nev)
{
    Dolgozat *uj = (Dolgozat*) malloc(sizeof(Dolgozat));
    strcpy(uj->fajlnev, fajlnev);
    strcpy(uj->nev, nev);
    uj->kifejezesek = NULL;
    uj->kov = NULL;

    return uj;
}


/* Felszabadít egy dolgozat listát. */
void dolgozatok_felszabadit(Dolgozat *dolgozatok)
{
    while (dolgozatok != NULL) {
        Dolgozat *temp = dolgozatok->kov;
        halmaz_felszabadit(dolgozatok->kifejezesek);
        free(dolgozatok);
        dolgozatok = temp;
    }
}


/* Visszaadja egy dolgozatlista hosszát. */
int dolgozatok_meret(Dolgozat* dolgozatok)
{
    int db = 0;
    while (dolgozatok != NULL) {
        db++;
        dolgozatok = dolgozatok->kov;
    }
    return db;
}


/* Igazzal tér vissza, ha szót elválasztó karaktert kap.
 * Ez szóköz (enter, tabulátor) vagy írásjel. */
static bool elvalaszto(char c)
{
    return isspace(c) || ispunct(c);
}


/* Beolvas egy szót az adott fájlból.
 * A szó végén szóköz vagy írásjel van. Az elejéről eldobja ezeket.
 * Igazzal tér vissza, ha beolvasott valami értékelhetőt.
 * Legfeljebb SZOHOSSZ karaktert olvas; annál hosszabb szavaknál
 * a többi karaktert eldobja. Így maximum SZOHOSSZ+1 bájtot ír
 * a tömbbe (lezáró nullával együtt.) */
static bool szot_beolvas(FILE *fp, char *szo)
{
    int c;
    while ((c = fgetc(fp)) != EOF && elvalaszto(c))
        ; /* üres */
    if (c == EOF)
        return false;
    int i = 0;
    szo[i++] = c;   /* első karakter */
    while ((c = fgetc(fp)) != EOF && !elvalaszto(c))
        if (i < SZOHOSSZ)
            szo[i++] = c;
    szo[i] = '\0';

    return i != 0;
}


/* Dolgozatok beolvasása.
 * Végigmegy a dolgozatok listán, és mindegyik megadott fájlt beolvassa.
 * Igazzal tér vissza, ha minden rendben volt. */
bool dolgozatok_beolvas(Dolgozat *dolgozatok)
{
    int fajlok = 0, kifejezesek = 0, meretek = 0;

    Dolgozat *iter;
    for (iter = dolgozatok; iter != NULL; iter = iter->kov) {
        char szo[SZOHOSSZ], elozoszo[SZOHOSSZ] = "";

        FILE *fp = fopen(iter->fajlnev, "rt");
        if (fp == NULL) {
            fprintf(stderr, "Nem lehet beolvasni a(z) %s fajlt!\n", iter->fajlnev);
            return false;
        }
        /* egyesével olvassa a szavakat */
        while (szot_beolvas(fp, szo)) {
            char kifejezes[2 * SZOHOSSZ];

            /* kifejezés = előző szó + mostani szó */
            strcpy(kifejezes, elozoszo);
            strcat(kifejezes, szo);
            halmaz_betesz(&iter->kifejezesek, kifejezes);
            kifejezesek++;

            /* következő iterációhoz */
            strcpy(elozoszo, szo);
        }
        fclose(fp);
        fajlok++;
        meretek += halmaz_meret(iter->kifejezesek);
    }

    printf("%d fajl, %d kifejezes beolvasva.\n"
           "A halmazok osszesen %d elemuek.\n",
           fajlok, kifejezesek, meretek);

    return true;
}
