#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <SDL.h>
#include <SDL_opengl.h>

#include "szinti.h"
#include "midi_text.h"

typedef struct Gomb {
    int nyomva;
    double szog;
} Gomb;


static void elsonagyobb(double *a, double *b) {
    if (*b > *a) {
        double temp = *a;
        *a = *b;
        *b = temp;
    }
}


static void teglatest(double x1, double y1, double z1, double x2, double y2, double z2) {
    elsonagyobb(&x2, &x1);
    elsonagyobb(&y2, &y1);
    elsonagyobb(&z2, &z1);
    glBegin(GL_QUADS);
    glNormal3d(0, 0, -1);    /* hatlap */
    glVertex3d(x1, y2, z1);
    glVertex3d(x2, y2, z1);
    glVertex3d(x2, y1, z1);
    glVertex3d(x1, y1, z1);
    glNormal3d(0, 0, +1);   /* elolap */
    glVertex3d(x1, y1, z2);
    glVertex3d(x2, y1, z2);
    glVertex3d(x2, y2, z2);
    glVertex3d(x1, y2, z2);
    glNormal3d(-1, 0, 0);   /* bal */
    glVertex3d(x1, y1, z1);
    glVertex3d(x1, y1, z2);
    glVertex3d(x1, y2, z2);
    glVertex3d(x1, y2, z1);
    glNormal3d(1, 0, 0);   /* jobb */
    glVertex3d(x2, y2, z1);
    glVertex3d(x2, y2, z2);
    glVertex3d(x2, y1, z2);
    glVertex3d(x2, y1, z1);
    glNormal3d(0, 1, 0);   /* felso */
    glVertex3d(x1, y2, z2);
    glVertex3d(x2, y2, z2);
    glVertex3d(x2, y2, z1);
    glVertex3d(x1, y2, z1);
    glNormal3d(0, -1, 0);   /* also */
    glVertex3d(x1, y1, z1);
    glVertex3d(x2, y1, z1);
    glVertex3d(x2, y1, z2);
    glVertex3d(x1, y1, z2);
    glEnd();
}


static void billentyurajzol(double xt, bool fekete, double szog) {
    double w = (fekete ? 0.5 : 0.9) / 2;  /* fel szelesseg */
    double y = fekete ? 0.6:0;             /* ennyivel van magasabban */
    double z2 = (fekete ? 3.5 : 5);        /* hosszusag */
    double magas = 1;                      /* billentyu magassaga */
    double szin = fekete ? 0.2 : 0.9;

    glPushMatrix();
    glTranslatef(xt, 0, 0);         /* itt kerulnek a helyukre */
    glRotated(szog, 1, 0, 0);       /* ettol vannak lenyomodva, x tengely korul forgas */
    glColor3d(szin, szin, szin);    /* ilyen szinu */
    teglatest(w, y, 0, -w, y-magas, z2);
    glPopMatrix();
}


static void zongorat_rajzol(Gomb *gombok) {
    int okt, i;
    int feketesor[] = {  1, 3, -1, 6, 8, 10 };
    int fehersor[] = { 0, 2, 4, 5, 7, 9, 11 };
    
    /* szek */
    glColor3d(0.5, 0.125, 0);
    teglatest(-5, -5, +10, +5, -6, +20);
    teglatest(-5, -6, +10, -4, -20, +11);
    teglatest(-5, -6, +19, -4, -20, +20);
    teglatest(+5, -6, +10, +4, -20, +11);
    teglatest(+5, -6, +19, +4, -20, +20);
    /* pianino */
    glColor3d(0.25, 0.125, 0);
    teglatest(-26, 2.7, 0, +25, -0.7, -1);  /* billentyuk folotti ize */
    teglatest(-26, 1, -1, -25, -1, 7);      /* billentyuktol balra */
    teglatest(+25, 1, -1, +24, -1, 7);      /* billentyuktol jobbra */
    teglatest(-26, -0.5, 6, +25, -1, 7);    /* billentyuk elott */
    teglatest(-26, -1, -1, +25, -2, 7);     /* billentyuk alatt */
    teglatest(-26, -2, 5, -25, -20, 6);     /* bal lab */
    teglatest(24, -2, 5, 25, -20, 6);       /* jobb lab */
    teglatest(-26, -20, -1, +25, +15, -10); /* a test */
    teglatest(-26, 15, 0, +25, +16, -10);   /* sapi */
    /* billentyuk */
    for (okt = 0; okt < 7; ++okt) {
        double x0 = (okt-3.5) * 7;
        for (i = 0; i < 7; ++i)
            billentyurajzol(x0 + i, false,  gombok[24 + okt*12 + fehersor[i]].szog);
        for (i = 0; i < 6; ++i)
            if (i != 2)
                billentyurajzol(x0 + (i + 0.5), true, gombok[24 + okt*12 + feketesor[i]].szog);
    }
}


Uint32 timer(Uint32 ms, void *param) {
    SDL_Event ev = {SDL_USEREVENT};
    SDL_PushEvent(&ev);
    return ms;
}


void lejatszas(Esemeny *l, Hang *h, int orajelpernegyed) {
    Hang *ez;
    Gomb gombok[128] = {{0}};     /* melyik gomb van lenyomva? */
    SDL_TimerID id;
    int felbontas = 20;
    int midiorajel = 0;
    double tempo = 500000;
    
    l = l->kov; /* strazsa atugrasa */
    
    id = SDL_AddTimer(felbontas, timer, NULL);
    bool kilep = false;
    while (!kilep) {
        SDL_Event ev;
        int i;

        SDL_WaitEvent(&ev);
        
        switch (ev.type) {
            case SDL_QUIT:
                kilep = true;
                break;
            case SDL_KEYDOWN:
                kilep = true;
                break;
            case SDL_USEREVENT:
                SDL_LockAudio();    /* hogy addig ne fusson a masik szal */
                hang_mar_nem_kell_torol(h);
                /* ennyi midi orajel ment le az elobbi idozites ota */
                midiorajel += (orajelpernegyed / (tempo/1000.0)) * felbontas;
                /* esemenyek az ujabb idoszeletbol */
                while (l != NULL && l->ido < midiorajel) {
                    switch (l->tipus) {
                        case tempobeallit:
                            tempo = l->tempo;
                            break;
                        case hangbe:
                            ez = hang_keres(h, l->csatorna, l->hangmagassag);
                            ez->all = felfutas;
                            ez->hangero = l->hangero/128.0;
                            gombok[l->hangmagassag].nyomva++;   /* kirajzolonak */
                            break;
                        case hangki:
                            ez = hang_keres(h, l->csatorna, l->hangmagassag);
                            ez->all = elengedes;
                            gombok[l->hangmagassag].nyomva--;   /* kirajzolonak */
                            break;
                    }
                    l = l->kov;
                }
                SDL_UnlockAudio();

                /* kirajzolas */
                for (i = 0; i < 128; ++i) {
                    if (gombok[i].nyomva > 0 && gombok[i].szog < 8)
                        gombok[i].szog+=4;
                    if (gombok[i].nyomva == 0 && gombok[i].szog > 0)
                        gombok[i].szog-=2;
                }

                /* rajzolas kezdete */
                glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
                glMatrixMode(GL_MODELVIEW);
                glLoadIdentity();
                gluLookAt(-20, 35, 70, 0, 0, 0, 0, 1, 0);

                /* fold - az elmaradhatatlan sakktabla */
                glBegin(GL_QUADS);
                glNormal3d(0, 1, 0);
                double x, z;
                for (x = -100; x<100; x+=10)
                    for (z = -100; z<100; z+=10) {
                        glColor3d(0, ((int)(x/10)^(int)(z/10)) & 1 ? 0.5 : 0.45, 0);
                        glVertex3d(x+10, -20, z);
                        glVertex3d(x, -20, z);
                        glVertex3d(x, -20, z+10);
                        glVertex3d(x+10, -20, z+10);
                    }
                glEnd();
                
                zongorat_rajzol(gombok);
                
                /* rajzolas vege, mehet a kepernyore */
                SDL_GL_SwapBuffers();

                break;
        }
    }
    SDL_RemoveTimer(id);
    if (!kilep)
        SDL_Delay(1000);
}


void grafika_init() {
    int w = 800, h = 600;
    SDL_SetVideoMode(w, h, 0, SDL_OPENGL);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(35.0, w / (double) h, 10, 300);
    glEnable(GL_DEPTH_TEST);            /* z-tarazas bekapcsolasa */
    glEnable(GL_LIGHTING);              /* fenyek szamitasa */
    glEnable(GL_LIGHT0);
    glEnable(GL_COLOR_MATERIAL);        /* az alakzatok anyaganak szinet a sokszogek szine adja meg */
    glClearColor(0.5, 0.5, 1, 1);       /* hatterszin: az eg szine */
}


int main(int argc, char *argv[]) {
    HangSzin hsz = { 0.01, 0.5, 0.66, 2, 0.2 };
    Hang hangstrazsa;
    Szinti sz = { 4096, &hsz, &hangstrazsa }; /* master volumne; hangszin; hangok */
    Esemeny esemenystrazsa;
    int orajelpernegyed = 24;
    
    esemenystrazsa.kov = NULL;
    hangstrazsa.kov = NULL;

    SDL_Init(SDL_INIT_EVERYTHING);

    fajl_beolvas(&esemenystrazsa, argv[1] ? argv[1] : "turc2.csv", &orajelpernegyed);

    grafika_init();
    hang_init(&sz);
    hang_start();
    lejatszas(&esemenystrazsa, &hangstrazsa, orajelpernegyed);
    hang_stop();

    esemeny_lista_felszab(&esemenystrazsa);
    hang_lista_felszab(&hangstrazsa);
    
    SDL_Quit();
    
    return 0;
}
