#include <SDL.h>
#include <math.h>
#include "szinti.h"

/* nehany globalis valtozo a hangok adataihoz */
static SDL_AudioSpec audiospec;
static double t = 0;

/* ez hivodik meg, amikor az SDL ujabb adag hangot ker tolunk */
void hang_callback(void *userdata, Uint8 *stream8, int len) {
    Szinti *sz = (Szinti *) userdata;
    HangSzin *hsz = sz->hangszin;
    Sint16 *stream = (Sint16 *) stream8;        /* a puffer, amit kaptunk: signed integer, 16 bit */
    double dt = 1.0 / audiospec.freq;           /* ennyi masodperc hangmintankent */
    int mintak, x;

    /* vegigmegyunk ezen az idoszeleten */
    mintak = len / sizeof(stream[0]);         /* mert bajtban szamol, nekunk meg mintak szama kell */
    for (x = 0; x < mintak; x++) {
        double s = 0;           /* az aktualis minta */
        Hang *h;

        /* es osszegzunk (osszemixelunk) minden hangot */
        for (h = sz->hangok->kov; h != NULL; h = h->kov) {
            double s_ez;
            double frek = 264 * pow(2, (h->hangmagassag - 60) * 1.0/12.0);
            
            /* felharmonikusok helyett */
            //~ s_ez = fmod(frek * t, 1)-0.5;                   // fureszfog
            s_ez = fabs(fmod(frek * t, 1)-0.5) * 4 - 1;     // haromszog

            /* itt kezeli a burkologorbet */
            switch (h->all) {
                case csend:
                    break;
                case felfutas:
                    h->adsrhangero += 1.0 / (hsz->felfutas_ido + 0.001) * dt;
                    if (h->adsrhangero > 1)
                        h->all = lecsenges;
                    break;
                case lecsenges:
                    h->adsrhangero -= 1.0 / (hsz->lecsenges_ido + 0.001) * dt;
                    if (h->adsrhangero < hsz->tartas_hangero)
                        h->all = tartas;
                    break;
                case tartas:
                    if (h->adsrhangero > 0)
                        h->adsrhangero -= 1.0 / (hsz->tartas_halkulas_ido + 0.001) * dt;
                    break;
                case elengedes:
                    h->adsrhangero -= 1.0 / (hsz->elengedes_ido + 0.001) * dt;
                    if (h->adsrhangero < 0) {
                        h->adsrhangero = 0;
                        h->all = csend;
                    }
                    break;
            }
            if (h->adsrhangero < -1.1 || h->adsrhangero > 1.1)
                abort();    /* vmi nagyon elrontva az allapotgepen */

            s += s_ez * h->adsrhangero * sz->hangero * h->hangero;
            
        }
        /* itt bekerul a pufferbe az osszemixelt minta */
        stream[x] = s;
        t += dt;                /* eltelt ennyi ido */
    }
}


/* SDL hanglejatszas inditasa */
void hang_init(Szinti *szinti) {
    audiospec.freq = 44100;                /* 44100Hz - CD minoseg, 48000 - dvd minoseg */
    audiospec.format = AUDIO_S16SYS;       /* 16-bit elojeles; a rendszer bajtsorrendjevel */
    audiospec.channels = 1;                /* mono */
    audiospec.samples = audiospec.freq/50; /* puffer merete - 1/50 sec */
    audiospec.callback = hang_callback;    /* sdl hivja, ha ujabb adag hang kell neki */
    audiospec.userdata = (void *) szinti;  /* egy pointert atad mindig a callbacknek */
    if (SDL_OpenAudio(&audiospec, NULL) < 0) {
        fprintf(stderr, "Hiba a hanggal: %s\n", SDL_GetError());
        exit(1);
    }
}


/* hang inditasa */
void hang_start(void) {
    SDL_PauseAudio(0);
}


/* hang inditasa */
void hang_stop(void) {
    SDL_PauseAudio(1);
}


/* megkeres egy hangot, esetleg be is szúrja egyből, ha nincs */
Hang *hang_keres(Hang *hangok, int csatorna, int hangmagassag) {
    Hang *iter;
    
    for (iter = hangok->kov; iter != NULL; iter = iter->kov)
        if (iter->csatorna == csatorna && iter->hangmagassag == hangmagassag)
            break;
    if (iter == NULL) {
        iter = (Hang *) malloc(sizeof(Hang));
        iter->csatorna = csatorna;
        iter->hangmagassag = hangmagassag;
        iter->adsrhangero = 0;
        iter->kov = hangok->kov;
        hangok->kov = iter;
    }
    return iter;
}


void hang_mar_nem_kell_torol(Hang *h) {
    /* esetleg torles */
    Hang *iter, *lemarado;
    lemarado = h;
    iter = h->kov;
    while (iter != NULL) {
        if (iter->all == csend) {
            lemarado->kov = iter->kov;
            free(iter);
            iter = lemarado->kov;
        } else {
            lemarado = iter;
            iter = iter->kov;
        }
    }
}


void hang_lista_felszab(Hang *h) {
    h = h->kov;     /* strazsat nem */
    while (h != NULL) {
        Hang *temp = h->kov;
        free(h);
        h = temp;
    }
}
