#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "lista.h"

/* dinamikusan foglalt memoriateruletre masol egy stringet */
char *malloc_string(char *string) 
{
    char *m = (char *)malloc(strlen(string) + 1);
    strcpy(m, string);
    return m;
}

/* voidkent veszi at a parameteret, es castolja */
void string_kiir(void *string)
{
    printf("%s ", (char *)string);
}

int main(void)
{
    Lista l;

    lista_uj(&l);
    lista_elejere(&l, malloc_string("alma"));
    lista_elejere(&l, malloc_string("korte"));
    lista_vegere(&l, malloc_string("szilva"));
    lista_vegere(&l, malloc_string("barack"));
    /* itt kicsit varazsolok a pointerekkel; a harmadik elemre mutatok.
     * l.eleje a strazsa, es onnantol szamolva 3x ->kovetkezo.
     * Letezik biztosan, mert 4 elemet raktam bele. */
    lista_beszur(l.eleje->kovetkezo->kovetkezo->kovetkezo, malloc_string("papaja"));

    printf("Beszurasok utan:\n");
    lista_mindegyiken(&l, string_kiir);
    printf("\n");
    /* itt castolom a fv-re mutato pointert, mert
       nem kompatibilis */
    lista_rendez(&l, (ListaElemHasonlito) strcmp);
    printf("Rendezes utan:\n");
    lista_mindegyiken(&l, string_kiir);
    printf("\n");

    /* felszabaditas - ez a mallocok parja tulajdonkepp */
    lista_mindegyiken(&l, free);
    lista_felszabadit(&l);

    return 0;
}
