#include <stdlib.h>

#include "lista.h"

/* letrehozza a strazsakat - ures listat csinal */
void lista_uj(Lista *l)
{
    l->eleje = (ListaElem *) malloc(sizeof(ListaElem));
    l->vege = (ListaElem *) malloc(sizeof(ListaElem));
    l->eleje->elozo = NULL;
    l->eleje->kovetkezo = l->vege;
    l->eleje->adat = NULL;  /* nem fontos, de jobb, ha van */
    l->vege->elozo = l->eleje;
    l->vege->kovetkezo = NULL;
    l->vege->adat = NULL;  /* nem fontos, de jobb, ha van */
}

/* listat felszabaditja */
void lista_felszabadit(Lista *l)
{
    ListaElem *futo;

    /* mindegy, hogy strazsa vagy rendes elem. */
    futo = l->eleje;
    while (futo != NULL) {
        ListaElem *temp = futo->kovetkezo;
        free(futo);
        futo = temp;
    }
}

void lista_mindegyiken(Lista *l, void (*fv)(void *))
{
    ListaElem *futo;

    for (futo = l->eleje->kovetkezo; futo != l->vege; futo = futo->kovetkezo)
        fv(futo->adat); /* amit a hivo ker */
}

/* lista elejere fuz egy elemet.
   l->e->k->l... rajz, rajz, rajz! */
void lista_elejere(Lista *l, void *adat)
{
    ListaElem *uj;

    uj = (ListaElem *) malloc(sizeof(ListaElem));
    uj->adat = adat;
    uj->kovetkezo = l->eleje->kovetkezo; /* az eddigi elso */
    uj->elozo = l->eleje; /* a strazsa */
    l->eleje->kovetkezo->elozo = uj; /* eddigi elso elotti ez lesz */
    l->eleje->kovetkezo = uj; /* strazsa utani ez lesz */
}

/* lista vegre fuz egy elemet */
void lista_vegere(Lista *l, void *adat)
{
    ListaElem *uj;

    uj = (ListaElem *) malloc(sizeof(ListaElem));
    uj->adat = adat;
    uj->kovetkezo = l->vege;
    uj->elozo = l->vege->elozo; /* az eddigi utolso */
    l->vege->elozo->kovetkezo = uj; /* eddigi utolso utan ez lesz */
    l->vege->elozo = uj; /* vegstrazsa elotti ez */
}

/* A megadott listaelem ele beszur egy ujat */
void lista_beszur(ListaElem *l, void *adat)
{
    ListaElem *uj;

    uj = (ListaElem *) malloc(sizeof(ListaElem));
    uj->adat = adat;
    /* o ramutat a leendo szomszedaira */
    uj->kovetkezo = l;
    uj->elozo = l->elozo;
    /* azok meg mutatnak ra */
    uj->elozo->kovetkezo = uj;
    uj->kovetkezo->elozo = uj;
}

/* buborekrendezi a listat. */
/* egyes rendezo algoritmusok konnyen implementalhatoak nem
   csak tombre, hanem (duplan lancolt) listara is. ilyenek
   peldaul a kozvetlen kivalasztasos, a buborek es a
   gyorsrendezes is. */
/* ez a fuggveny vegigmegy a listan, es az egymas melletti elemeket
   megcsereli, ha rossz sorrendben vannak. ezaltal a legnagyobb elem
   tuti a lista vegere kerul; legkozelebb mar csak az utolso elotti
   elemig kell menni ugyanezzekkel a cserekkel. es igy tovabb */
/* ezt is szinte keptelenseg rajz nelkul megcsinalni. */
void lista_rendez(Lista *l, ListaElemHasonlito hasonlit)
{
    ListaElem *meddig;

    /* ures listat nem rendezzuk. ez azert is kell, mivel
       kulonben a lenti while ciklus feltetele orokke igaz lenne */
    if (l->eleje->kovetkezo == l->vege)
        return;
    /* a meddig fogja tartalmazni az utolso osszehasonlitando
       elemet (amit mar nem kell osszehasonlitani majd,
       hiszen nincs utana kovetkezo) */
    meddig = l->vege->elozo;
    /* amikor a meddig elerte a legelso elemet,
       akkor mar nem lesz mit csinalni */
    while (meddig != l->eleje->kovetkezo) {
        ListaElem *futo;

        for (futo = l->eleje->kovetkezo; futo != meddig; futo = futo->kovetkezo)
            if (hasonlit(futo->adat, futo->kovetkezo->adat) > 0) {
                /* egyszerubb az adataikat megcserelni,
                   hiszen az jelen esetben csak egy pointer */
                void *temp = futo->adat;
                futo->adat = futo->kovetkezo->adat;
                futo->kovetkezo->adat = temp;
            }

        /* az utolso elem a helyere kerult; ennyivel kevesebbet
           rendezunk a kovetkezo korben */
        meddig = meddig->elozo;
    }
}
