#ifndef TABLAZAT_H
#define TABLAZAT_H

#include <stdbool.h>


/* A táblázatkezelő típusai és függvényei */
typedef struct cella {
    char *tartalom;
    double cachelt_ertek;
    bool kiszamolva;
    bool mar_jartunk_itt;
} cella;


typedef struct tablazat {
    cella **adat;
    int szelesseg;
    int magassag;
} tablazat;


tablazat *tablazat_uj(int szelesseg, int magassag);
void tablazat_kiir(tablazat *a_tablazat);
void tablazat_felszabadit(tablazat *a_tablazat);


bool cella_kiszamol(tablazat *a_tablazat, int sor, int oszlop);
bool cella_modosit(tablazat *a_tablazat, int sor, int oszlop, char const *tartalom);


#endif /* TABLAZAT_H */
