#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "elemzo.h"
#include "tablazat.h"


static void tablazat_kiszamolva_nullaz(tablazat *a_tablazat);


bool cella_kiszamol(tablazat *a_tablazat, int sor, int oszlop) {
    cella *a_cella = &a_tablazat->adat[sor][oszlop];
    
    /* ha már jártunk itt, körkörös hivatkozás van. hibával térünk vissza. */
    if (a_cella->mar_jartunk_itt)
        return false;
    /* ha már ki van számolva, nincs dolgunk */
    if (a_cella->kiszamolva)
        return true;

    /* megjelöljük a cellát. visszatérés előtt ezt visszaállítjuk majd hamisra. */
    a_cella->mar_jartunk_itt = true;

    if (a_cella->tartalom == NULL) {
        a_cella->cachelt_ertek = 0;
        a_cella->kiszamolva = true;
        a_cella->mar_jartunk_itt = false;
        return true;
    }
    else {
        /* Ha itt vagyunk, akkor vagy szöveg, vagy képlet a cella tartalma
         * -- akkor képlet, ha az első nem-szóköz karakter egy '=' */
        int poz;

        /* Megkeressük az első nem-szóköz karaktert */
        for (poz = 0; isspace(a_cella->tartalom[poz]); ++poz)
            ; /* üres */

        if (a_cella->tartalom[poz] != '=') {
            a_cella->cachelt_ertek = 0;
            a_cella->kiszamolva = true;
            a_cella->mar_jartunk_itt = false;
            return true;
        }
        else {
            double ertek;
            /* +poz+1: hogy az '='-t ne adjuk oda az elemzőnek */
            if (kiertekel(a_cella->tartalom + poz + 1, &ertek, a_tablazat)) {
                a_cella->cachelt_ertek = ertek;
                a_cella->kiszamolva = true;
                a_cella->mar_jartunk_itt = false;
                return true;
            }
        }
    }

    a_cella->mar_jartunk_itt = false;
    return false; /* Ha ide jutottunk, akkor nem sikerült kiszámolni a cella értékét, tehát hibás a tartalom. */
}


bool cella_modosit(tablazat *a_tablazat, int sor, int oszlop, char const *tartalom) {
    char *regi = a_tablazat->adat[sor][oszlop].tartalom;
    char *uj = (char *)malloc((strlen(tartalom) + 1) * sizeof(char));
    if (uj == NULL)
        return false;
    strcpy(uj, tartalom);
    
    /* mindent újra kell számolni, nehogy a cache-elés megzavarja */
    tablazat_kiszamolva_nullaz(a_tablazat);

    /* megpróbáljuk betenni az újat */
    a_tablazat->adat[sor][oszlop].tartalom = uj;
    if (cella_kiszamol(a_tablazat, sor, oszlop)) {
        free(regi);
        return true;
    }
    else {
        free(uj);
        a_tablazat->adat[sor][oszlop].tartalom = regi;
        return false;
    }
}


tablazat *tablazat_uj(int szelesseg, int magassag) {
    tablazat *uj_tablazat;
    int i, j;

    /* táblázat */
    uj_tablazat = (tablazat *)malloc(sizeof(tablazat));
    if (uj_tablazat == NULL) return NULL;
    /* sorok pointertömbje */
    uj_tablazat->adat = (cella **)malloc(magassag * sizeof(cella *));
    if (uj_tablazat->adat == NULL) {
        free(uj_tablazat);
        return NULL;
    }
    /* cellák tömbje (az összes sorfolytonosan) */
    uj_tablazat->adat[0] = (cella *)malloc((magassag * szelesseg) * sizeof(cella));
    if (uj_tablazat->adat[0] == NULL) {
        free(uj_tablazat->adat);
        free(uj_tablazat);
        return NULL;
    }
    for (i = 1; i < magassag; ++i) {
        uj_tablazat->adat[i] = uj_tablazat->adat[0] + (i * szelesseg);
    }

    /* összes cella nulla minden */
    for (j = 0; j < magassag; ++j) {
        for (i = 0; i < szelesseg; ++i) {
            uj_tablazat->adat[j][i].tartalom = NULL;
            uj_tablazat->adat[j][i].cachelt_ertek = 0;
            uj_tablazat->adat[j][i].kiszamolva = false;
            uj_tablazat->adat[j][i].mar_jartunk_itt = false;
        }
    }

    uj_tablazat->szelesseg = szelesseg;
    uj_tablazat->magassag = magassag;

    return uj_tablazat;
}


void tablazat_felszabadit(tablazat *a_tablazat) {
    int i, j;

    /* minden cella dinamikusan foglalt */
    for (j = 0; j < a_tablazat->magassag; ++j) {
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            free(a_tablazat->adat[j][i].tartalom);
        }
    }
    /* az adatszerkezet */
    free(a_tablazat->adat[0]);
    free(a_tablazat->adat);
    free(a_tablazat);
}


void tablazat_kiir(tablazat *a_tablazat) {
    int i, j;
    int hiba_van = 0;

    /* mindent kiszámol */
    tablazat_kiszamolva_nullaz(a_tablazat);
    for (j = 0; !hiba_van && j < a_tablazat->magassag; ++j) {
        for (i = 0; !hiba_van && i < a_tablazat->szelesseg; ++i) {
            if (!cella_kiszamol(a_tablazat, j, i)) {
                printf("Hiba történt a %c%d cella kiszámolásakor.\n", 'A' + i, j);
                hiba_van = 1;
            }
        }
    }

    /* táblázat kirajzolása */
    if (!hiba_van) {
        /* fejléc */
        printf("---+");
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            printf("-----------+");
        }
        printf("\n");
        printf("   |");
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            printf("     %c     |", 'A' + i);
        }
        printf("\n");
        printf("---+");
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            printf("-----------+");
        }
        printf("\n");

        /* sorok */
        for (j = 0; j < a_tablazat->magassag; ++j) {
            printf("%2d |", j);
            for (i = 0; i < a_tablazat->szelesseg; ++i) {
                if (a_tablazat->adat[j][i].tartalom == NULL) {
                    printf("          ");
                }
                else {
                    int poz;
                    for (poz = 0; isspace(a_tablazat->adat[j][i].tartalom[poz]); ++poz)
                        ;

                    if (a_tablazat->adat[j][i].tartalom[poz] == '=') {
                        printf("%10g", a_tablazat->adat[j][i].cachelt_ertek);
                    }
                    else {
                        char cella_szoveg[11];
                        
                        strncpy(cella_szoveg, a_tablazat->adat[j][i].tartalom, 10);
                        cella_szoveg[10] = '\0';

                        printf("%-10s", cella_szoveg);
                    }
                }
                printf(" |");
            }
            printf("\n");
        }
        
        /* lábléc */
        printf("---+");
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            printf("-----------+");
        }
        printf("\n");
    }
}


static void tablazat_kiszamolva_nullaz(tablazat *a_tablazat) {
    int i, j;

    for (j = 0; j < a_tablazat->magassag; ++j) {
        for (i = 0; i < a_tablazat->szelesseg; ++i) {
            a_tablazat->adat[j][i].kiszamolva = false;
        }
    }
}
