#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "tablazat.h"


void sorveg_kivesz(char *str);


int main() {
    bool kilep = false;

    tablazat *a_tablazat = tablazat_uj(5, 5);
    
    printf("Táblázatkezelő\n\n");
    printf("Használat:\n");
    printf("  kilep: kilépés\n");
    printf("  kiir: táblázat kiírása\n");
    printf("  vizsgal C4: C4 képletének kiírása\n");
    printf("  modosit C4=képlet: C4 képletének megadása\n");
    printf("  modosit C4 sztring: sztring beírása C4-be\n");
    printf("  (Ha az első nem-szóköz karakter '=', akkor az egy képlet.)\n\n");

    tablazat_kiir(a_tablazat);

    do {
        char utasitas[255];
        
        printf("\nUtasítás: ");
        while (!fgets(utasitas, 255, stdin)) {
            printf("\nHibás beolvasás.\n\nUtasitas: ");
        }

        if (strstr(utasitas, "kilep") == utasitas) {
            kilep = true;
        }
        else if (strstr(utasitas, "kiir") == utasitas) {
            tablazat_kiir(a_tablazat);
        }
        else if (strstr(utasitas, "vizsgal") == utasitas) {
            char oszlop;
            int sor;

            if (sscanf(utasitas + strlen("vizsgal "), " %c%d", &oszlop, &sor) == 2) {
                oszlop = toupper(oszlop);
                printf("\n%c%d: %s\n", oszlop, sor, a_tablazat->adat[sor][oszlop - 'A'].tartalom);
            }
        }
        else if (strstr(utasitas, "modosit") == utasitas) {
            char oszlop;
            int sor;
            char *utasitas_mozgo = utasitas + strlen("modosit ");

            if (sscanf(utasitas_mozgo, " %c%d", &oszlop, &sor) == 2) {
                oszlop = toupper(oszlop);
                utasitas_mozgo += 2;
                sorveg_kivesz(utasitas_mozgo);
                if (!cella_modosit(a_tablazat, sor, oszlop - 'A', utasitas_mozgo))
                    printf("A cella tartalma nem módosítható: a kifejezés hibás.\n");
            }
        }
        else {
            if (strcmp(utasitas, "")!=0)
                printf("Hibás utasítás: %s\n", utasitas);
        }
    } while (!kilep);

    tablazat_felszabadit(a_tablazat);

    return 0;
}


void sorveg_kivesz(char *str) {
    for (; *str != '\0'; ++str) {
        if (*str == '\n') *str = ' ';
    }
}
