#ifndef JATEKALLAS_H
#define JATEKALLAS_H

#include <stdbool.h>

/** A pálya egy cellája, vagy játékos. */
typedef enum Babu {
    b_ures, b_kor, b_iksz
} Babu;

/** A pályán egy pozíció, x és y koordináta. */
typedef struct Pozicio {
    int x, y;
} Pozicio;

/** A játékállásról minden információ. */
typedef struct Jatek {
    Babu palya[3][3];
    Babu kovetkezo;
    char kor_nev[100+1];
    char iksz_nev[100+1];
} Jatek;

void jatek_uj(Jatek *pj, char const *kor, char const *iksz);
char const * jatek_kovetkezo_neve(Jatek const *pj);
bool jatek_lep(Jatek *pj, Pozicio p);
bool jatek_ment(Jatek const *pj, char const *fajlnev);
bool jatek_betolt(Jatek *pj, char const *fajlnev);

#endif
