#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "jatekallas.h"

/**
 * Új játékot kezd.
 */
void jatek_uj(Jatek *pj, char const *kor, char const *iksz) {
    /* a kör kezd */
    pj->kovetkezo = b_kor;

    /* üres pályán */
    for (int y = 0; y < 3; ++y)
        for (int x = 0; x < 3; ++x)
            pj->palya[y][x] = b_ures;

    /* nevek */
    strcpy(pj->kor_nev, kor);
    strcpy(pj->iksz_nev, iksz);
}

/**
 * Megadja annak a játékosnak a nevét, aki a következő lépést teszi majd.
 * @return A játékos neve, egy sztring.
 */
char const * jatek_kovetkezo_neve(Jatek const *pj) {
    switch (pj->kovetkezo) {
        case b_kor:
            return pj->kor_nev;
        case b_iksz:
            return pj->iksz_nev;
        default:
            assert(false);  // lehetetlen esemény
    }
}


/**
 * Megadja, ki a következő játékos, ha most a megadott játékos lépett.
 */
static Babu kovetkezo(Babu j) {
    switch (j) {
        case b_kor:
            return b_iksz;
        case b_iksz:
            return b_kor;
        default:
            assert(false);  // ilyen nem történhet
    }
}


/**
 * Megmondja, hogy egy adott pozícióból adott irányba indulva
 * az adott cella van-e mindhárom helyen.
 */
static bool harmas(Jatek const *pj, Pozicio p, Pozicio i, Babu c) {
    for (int n = 0; n < 3; ++n)
        if (pj->palya[p.y + n * i.y][p.x + n * i.x] != c)
            return false;
    return true;
}


/**
 * Megmondja, van-e hármasa (nyert-e) az adott játékos.
 * @return true, ha igen.
 */
static bool nyert_e(Jatek const *pj, Babu keresett) {
    /* hol lehet, milyen irányokban? 3 vízszintes, 3 függőleges, 2 átlós. */
    for (int y = 0; y < 3; ++y)
        if (harmas(pj, (Pozicio){0, y}, (Pozicio){1, 0}, keresett))
            return true;
    for (int x = 0; x < 3; ++x)
        if (harmas(pj, (Pozicio){x, 0}, (Pozicio){0, 1}, keresett))
            return true;
    if (harmas(pj, (Pozicio){0, 0}, (Pozicio){1, 1}, keresett))
        return true;
    if (harmas(pj, (Pozicio){0, 2}, (Pozicio){1, -1}, keresett))
        return true;
    return false;
}


/**
 * Lép a megadott játékos a megadott pozícióra.
 * @return true, ha ezzel a lépésével megnyeri a játékot.
 */
bool jatek_lep(Jatek *pj, Pozicio p) {
    pj->palya[p.y][p.x] = pj->kovetkezo;
    bool nyert = nyert_e(pj, pj->kovetkezo);
    pj->kovetkezo = kovetkezo(pj->kovetkezo);
    return nyert;
}


/**
 * Elmenti a játékot egy fájlba.
 * @param pj A mentendő játék.
 * @param fajlnev A fájl neve, amit létrehoz.
 * @return true, ha sikeres volt a mentés.
 */
bool jatek_ment(Jatek const *pj, char const *fajlnev) {
    FILE *fp;
    fp = fopen(fajlnev, "wt");
    if (fp == NULL)
        return false;
    fprintf(fp, "Tictactoe v1\n");
    fprintf(fp, "%s\n", pj->kor_nev);
    fprintf(fp, "%s\n", pj->iksz_nev);
    fprintf(fp, "%d\n", (int) pj->kovetkezo);
    for (int y = 0; y < 3; ++y) {
        for (int x = 0; x < 3; ++x)
            fprintf(fp, "%d ", (int) pj->palya[y][x]);
        fprintf(fp, "\n");
    }
    fclose(fp);
    return true;
}


/**
 * Visszatölti a játékot a fájlból. Felülírja a paramterként adott játékot.
 * @param pj A játék objektum, amibe a fájlból írja az adatokat.
 * @param fajlnev A fájl neve, amiből olvasni kell.
 * @return true, ha sikeres volt.
 */
bool jatek_betolt(Jatek *pj, char const *fajlnev) {
    FILE *fp;
    fp = fopen(fajlnev, "rt");
    if (fp == NULL)
        return false;
    int v;
    fscanf(fp, "Tictactoe v%d", &v);    // itt ellenőriznénk a verziót
    fscanf(fp, " %[^\n]", pj->kor_nev);
    fscanf(fp, " %[^\n]", pj->iksz_nev);
    int ki_jon;
    fscanf(fp, "%d", &ki_jon);
    pj->kovetkezo = (Babu) ki_jon;
    for (int y = 0; y < 3; ++y) {
        for (int x = 0; x < 3; ++x) {
            int c;
            fscanf(fp, "%d", &c);
            pj->palya[y][x] = (Babu) c;
        }
    }
    fclose(fp);
    return true;
}
