#include <stdio.h>
#include <string.h>

#include "ertelmezo.h"
#include "halmaz.h"
#include "kifejezesek.h"

char *help[] = {
    "SZÁMOLÓGÉP PROGRAM",
    "",
    "Írj be a kérdőjel után a négy alapműveletet és tetszőleges mélységű zárójeleket tartalmazó kifejezést.",
    "Kilépéshez írd be a \"kilep\" szót.",
    "",
    "Használhatsz változókat is. Egy változó neve betűvel kezdődik, és betűket és számokat tartalmazhat.",
    "",
    "Az értékadó operátor megegyezik a C nyelv értékadó operátorával és a főhatása is ugyanaz, tehát értelmes az alábbi kifejezés:",
    "a = 5 * (b = 6)",
    "ahol a értéke 30, b értéke pedig 6 lesz. Az értékadó operátor láncolható is:",
    "a = b = 6",
    "ekkor mind a, mind b értéke 6 lesz.",
    "",
    "Van két alapértelmezett változó: PI és E.",
    "",
    "Ha egy változó értékét hamarabb kérdezed le, mint ahogy értéket adnál neki (nagyon csúnya dolog a programozásban!),",
    "akkor létre fog jönni és 0 értékre inicializálódik.",
    "",
    "Az kifejezeseket megszámozza a program és a sorszámra hivatkozva az \"ismetel\" paranccsal újra ki lehet értékelni azokat:",
    "[12] ? a = 7",
    "A kifejezés értéke: 7",
    "[13] ? 12 + a",
    "A kifejezés értéke: 19",
    "[14] ? a = 2",
    "A kifejezés értéke: 2",
    "[15] ismetel 13",
    "[13] > 12 + a",
    "A kifejezés értéke: 14",
    "",
    "",
    NULL
};

int main() {
    char szoveg[255] = {0};
    szimbolum *ast = NULL;
    valtozo *valtozok = NULL;
    kifejezesek *a_kifejezesek = NULL;
    int i;
    bool kilep = false;
    unsigned egyenlet_szam;

    *lekerdez(&valtozok, "PI") = 3.14159265359;
    *lekerdez(&valtozok, "E")  = 2.71828182846;

    for (i = 0; help[i]; ++i) printf("%s\n", help[i]);

    egyenlet_szam = 0;
    do {
        printf("[%d] ? ", egyenlet_szam);
        fgets(szoveg, 254, stdin);

        if (strstr(szoveg, "kilep") == szoveg) kilep = true;
        else if (strstr(szoveg, "ismetel") == szoveg) {
            sscanf(szoveg + strlen("ismetel"), "%u", &i);
            ast = kifejezesek_leker(a_kifejezesek, i, szoveg);

            printf("[%d] > %s", i, szoveg);
            printf("A kifejezés értéke: %g.\n", ast_kiertekel(ast, &valtozok));
        }
        else if (kiertekel(szoveg, &ast)) {
            printf("A kifejezés értéke: %g.\n", ast_kiertekel(ast, &valtozok));
            kifejezesek_vegere_berak(&a_kifejezesek, szoveg, ast);
            ++egyenlet_szam;
        }
        else {
            printf("Nem sikerült értelmezni a kifejezést.\n");
        }

    } while (!kilep);

    kifejezesek_torol(a_kifejezesek);
    valtozok_torol(valtozok);

    return 0;
}

