#include <stdlib.h>
#include <string.h>
#include "kifejezesek.h"


void kifejezesek_vegere_berak(kifejezesek **a_kifejezesek, char const *szoveg, szimbolum *ast) {
    kifejezesek *mozgo = *a_kifejezesek;
    kifejezesek *uj = (kifejezesek *)malloc(sizeof(kifejezesek));

    if (uj == NULL) return;
    strncpy(uj->szoveg, szoveg, 254);
    uj->szoveg[254] = 0;
    uj->ast = ast;
    uj->kovetkezo = NULL;

    if (mozgo == NULL) {
        *a_kifejezesek = uj;
    }
    else {
        for (; mozgo->kovetkezo != NULL; mozgo = mozgo->kovetkezo);
        mozgo->kovetkezo = uj;
    }
}

/*
 * Visszaadja az egyenlet_szam. egyenletet és az egyenlet_szoveg változóba bemásolja a szövegét.
 */
szimbolum *kifejezesek_leker(kifejezesek *a_kifejezesek, unsigned egyenlet_szam, char *egyenlet_szoveg) {
    unsigned i;
    kifejezesek *mozgo;

    for (i = 0, mozgo = a_kifejezesek; mozgo != NULL && i < egyenlet_szam; ++i, mozgo = mozgo->kovetkezo);

    if (mozgo == NULL) return NULL;
    else {
        strncpy(egyenlet_szoveg, mozgo->szoveg, 254);
        mozgo->szoveg[254] = 0;

        return mozgo->ast;
    }
}

void kifejezesek_torol(kifejezesek *a_kifejezesek) {
    kifejezesek *mozgo;

    mozgo = a_kifejezesek;
    while (mozgo != NULL) {
        kifejezesek *tmp = mozgo->kovetkezo;

        ast_torol(mozgo->ast);
        free(mozgo);

        mozgo = tmp;
    }
}

