#ifndef ERTELMEZO
#define ERTELMEZO

#include <stdbool.h>
#include "halmaz.h"

/*
    A NYELVTAN:

    ertekado_kifejezes = [valtozonev '='] osszeg
    osszeg = ertekado_kifejezes | (szorzat {('+' | '-') szorzat})
    szorzat = tenyezo {('*' | '/') tenyezo}
    tenyezo = szam | zarojeles | valtozonev
    zarojeles = '(' ertekado_kifejezes ')'
*/

/* Az AST típusai */
typedef enum {MUVELET, SZAM, VALTOZO, ERTEKADAS} szimbolum_tipus;

/*
 * Elődeklaráljuk a szimbolumot, mert használja az ertekadas, amit viszont
 * használ a szimbolum.
 */
struct szimbolum;

typedef struct ertekadas {
    char nev[51];
    struct szimbolum *kifejezes;
} ertekadas;

typedef struct szimbolum {
    szimbolum_tipus tipus;
    union {
        double szam;
        char muveleti_jel;
        char nev[51];
        ertekadas egy_ertekadas;
    } adat;

    struct szimbolum *op1, *op2;
} szimbolum;

/* Az AST függvényei */
void ast_kiir(szimbolum *ast);
double ast_kiertekel(szimbolum *ast, valtozo **valtozok);
void ast_torol(szimbolum *ast);

/* Az értelmező függvénye */
bool kiertekel(char *szoveg, szimbolum **ast);

#endif
