#include <stdio.h>
#include <string.h>
#include "ertelmezo.h"
#include "halmaz.h"

char *help[] = {
    "SZÁMOLÓGÉP PROGRAM",
    "",
    "Írj be a kérdőjel után a négy alapműveletet és tetszőleges mélységű zárójeleket tartalmazó kifejezést.",
    "Kilépéshez írd be a \"kilep\" szót.",
    "",
    "Használhatsz változókat is. Egy változó neve betűvel kezdődik, és betűket és számokat tartalmazhat.",
    "",
    "Az értékadó operátor megegyezik a C nyelv értékadó operátorával és a főhatása is ugyanaz, tehát értelmes az alábbi kifejezés:",
    "a = 5 * (b = 6)",
    "ahol a értéke 30, b értéke pedig 6 lesz. Az értékadó operátor nem láncolható, de zárójelek segítségével ez is megoldható:",
    "a = (b = 6)",
    "ekkor mind a, mind b értéke 6 lesz.",
    "",
    "Van két alapértelmezett változó: PI és E.",
    "",
    "Ha egy változó értékét hamarabb kérdezed le, mint ahogy értéket adnál neki (nagyon csúnya dolog a programozásban!),",
    "akkor létre fog jönni és 0 értékre inicializálódik.",
    "",
    NULL
};

int main() {
    char szoveg[255] = {0};
    szimbolum *ast = NULL;
    valtozo *valtozok = NULL;
    bool kilep = false;
    int i;

    *lekerdez(&valtozok, "PI") = 3.14159265359;
    *lekerdez(&valtozok, "E")  = 2.71828182846;

    for (i = 0; help[i]; ++i) printf("%s\n", help[i]);

    do {
        printf("? ");
        fgets(szoveg, 254, stdin);

        if (strstr(szoveg, "kilep") == szoveg) kilep = true;
        else if (kiertekel(szoveg, &ast)) {
            printf("Az kifejezés értéke: %g.\n", ast_kiertekel(ast, &valtozok));
        }
        else {
            printf("Nem sikerült értelmezni a kifejezést.\n");
        }

        ast_torol(ast);
        ast = NULL;
    } while (!kilep);

    return 0;
}

