#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "halmaz.h"

/**
 * Ha olyan nevet adunk meg, ami még nem szerepelt a listába, akkor a megadott értékkel inicializálva
 * berakja őt a halmazba. Ha a név már szerepel a halmazban, akkor visszaadja a megtalált nevet, de nem írja
 * felül a megadott értékkel. Erre azért van szükség, mert ha egyszerűen le akarunk kérdezni egy változót, akkor
 * is őt használjuk a lekerdez függvényen keresztül.
 */
static valtozo *berak(valtozo **valtozok, char const *nev, double ertek);

/**
 * Egy egyszerű keresést végez és NULL-t ad vissza, ha nem volt találat.
 */
static valtozo *keres(valtozo **valtozok, char const *nev);

double *lekerdez(valtozo **valtozok, char const *nev) {
    return &(berak(valtozok, nev, 0.0)->ertek);
}


static valtozo *berak(valtozo **valtozok, char const *nev, double ertek) {
    valtozo *mozgo = keres(valtozok, nev);

    if (mozgo == NULL) {
        valtozo *uj = (valtozo *)malloc(sizeof(valtozo));

        if (uj == NULL) {
            fprintf(stderr, "Memóriafoglalási hiba\n");
            return NULL;
        }

        strncpy(uj->nev, nev, 50); uj->nev[50] = 0;
        uj->ertek = ertek;
        uj->kovetkezo = *valtozok;
        *valtozok = uj;

        return uj;
    }
    else return mozgo;

}

static valtozo *keres(valtozo **valtozok, char const *nev) {
    valtozo *mozgo;

    for (mozgo = *valtozok; mozgo != NULL && strcmp(nev, mozgo->nev) != 0; mozgo = mozgo->kovetkezo);

    return mozgo;
}
