#ifndef ERTELMEZO
#define ERTELMEZO

#include <stdbool.h>

/*
    A NYELVTAN:

    osszeg = szorzat {('+' | '-') szorzat}
    szorzat = tenyezo {('*' | '/') tenyezo}
    tenyezo = szam | zarojeles
    zarojeles = '(' osszeg ')'
*/

/* Az AST típusai */
typedef enum {MUVELET, SZAM} szimbolum_tipus;

typedef struct szimbolum {
    szimbolum_tipus tipus;
    union {
        double szam;
        char muveleti_jel;
    } adat;

    struct szimbolum *op1, *op2;
} szimbolum;

/* Az AST függvényei */
void ast_kiir(szimbolum *ast);
double ast_kiertekel(szimbolum *ast);
void ast_torol(szimbolum *ast);

/* Az értelmező függvénye */
bool kiertekel(char *szoveg, szimbolum **ast);

#endif
