#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <ctype.h>
#include "ertelmezo.h"


/* Az AST függvényei */
static szimbolum *uj_muvelet(char muveleti_jel);
static szimbolum *uj_szam(double ertek);

/* Lexer függvények */
static bool szokoz(char **szoveg);
static bool karakter(char **szoveg, char const *ertekkeszlet, char *talalat);
static bool szam(char **szoveg, double *ertek);

/* Parser függvények */
static bool osszeg(char **szoveg, szimbolum **ast);
static bool szorzat(char **szoveg, szimbolum **ast);
static bool tenyezo(char **szoveg, szimbolum **ast);
static bool zarojeles(char **szoveg, szimbolum **ast);

/* Lexer függvények */
bool szokoz(char **szoveg) {
    while (**szoveg != '\0' && isspace(**szoveg)) *szoveg += 1;
    return true;
}

bool karakter(char **szoveg, char const *ertekkeszlet, char *talalat) {
    char *eleje = *szoveg;
    szokoz(szoveg);

    while (*ertekkeszlet && **szoveg != *ertekkeszlet) {
        ++ertekkeszlet;
    }

    if (*ertekkeszlet == 0) {
        *szoveg = eleje;
        return false;
    }
    else {
        *talalat = *ertekkeszlet;
        *szoveg += 1;
        return true;
    }
}

bool szam(char **szoveg, double *ertek) {
    char *eleje = *szoveg;
    char kar;

    szokoz(szoveg);
    if (karakter(szoveg, "+-0123456789", &kar)) {
        double szam;
        int bajtok;

        *szoveg -= 1;
        if (sscanf(*szoveg, "%lf%n", &szam, &bajtok) > 0) {
            *szoveg += bajtok;
            *ertek = szam;
            return true;
        }
        else {
            *szoveg = eleje;
            return false;
        }
    }
    else {
        *szoveg = eleje;
        return false;
    }
}

/* Parser függvények */
bool osszeg(char **szoveg, szimbolum **ast) {
    char *munka = *szoveg;
    char kar;
    szimbolum *op1, *op2, *uj = NULL;

    szokoz(&munka);
    if (szorzat(&munka, &op1)) {
        while (karakter(&munka, "+-", &kar)) {
            if (szorzat(&munka, &op2)) {
                uj = uj_muvelet(kar);
                uj->op1 = op1;
                uj->op2 = op2;

                op1 = uj;
            }
            else return false;
        }

        if (uj == NULL) *ast = op1;
        else *ast = uj;

        *szoveg = munka;
        return true;
    }
    else {
        return false;
    }
}

bool szorzat(char **szoveg, szimbolum **ast) {
    char *munka = *szoveg;
    char kar;
    szimbolum *op1, *op2, *uj = NULL;

    szokoz(&munka);
    if (tenyezo(&munka, &op1)) {
        while (karakter(&munka, "*/", &kar)) {
            if (tenyezo(&munka, &op2)) {
                uj = uj_muvelet(kar);
                uj->op1 = op1;
                uj->op2 = op2;

                op1 = uj;
            }
            else return false;
        }

        if (uj == NULL) *ast = op1;
        else *ast = uj;

        *szoveg = munka;
        return true;
    }
    else {
        return false;
    }
}

bool tenyezo(char **szoveg, szimbolum **ast) {
    char *munka = *szoveg;
    double ertek;

    szokoz(&munka);
    if (zarojeles(&munka, ast)) {
        *szoveg = munka;
        return true;
    }
    else if (szam(&munka, &ertek)) {
        *ast = uj_szam(ertek);
        *szoveg = munka;
        return true;
    }
    else {
        return false;
    }

}

bool zarojeles(char **szoveg, szimbolum **ast) {
    char *munka = *szoveg;
    char kar;

    szokoz(&munka);
    if (karakter(&munka, "(", &kar) && osszeg(&munka, ast) && karakter(&munka, ")", &kar)) {
        *szoveg = munka;
        return true;
    }
    else {
        return false;
    }
}

/* Az AST függvényei */
szimbolum *uj_muvelet(char muveleti_jel) {
    szimbolum *uj = (szimbolum *)malloc(sizeof(szimbolum));

    if (uj == NULL) return NULL;

    uj->tipus = MUVELET;
    uj->adat.muveleti_jel = muveleti_jel;
    uj->op1 = uj->op2 = NULL;

    return uj;
}

szimbolum *uj_szam(double ertek) {
    szimbolum *uj = (szimbolum *)malloc(sizeof(szimbolum));

    if (uj == NULL) return NULL;

    uj->tipus = SZAM;
    uj->adat.szam = ertek;
    uj->op1 = uj->op2 = NULL;

    return uj;
}

void ast_kiir(szimbolum *ast) {
    if (ast != NULL) {
        ast_kiir(ast->op1);

        if (ast->tipus == SZAM) {
            printf(" %g ", ast->adat.szam);
        }
        else {
            printf(" %c ", ast->adat.muveleti_jel);
        }

        ast_kiir(ast->op2);
    }
}

void ast_torol(szimbolum *ast) {
    if (ast != NULL) {
        ast_torol(ast->op1);
        ast_torol(ast->op2);
        free(ast);
    }
}

double ast_kiertekel(szimbolum *ast) {
    if (ast == NULL) return 0.0;
    else {
        double op1 = ast_kiertekel(ast->op1), op2 = ast_kiertekel(ast->op2);

        switch (ast->tipus) {
            case SZAM:
                return ast->adat.szam;

            case MUVELET:
                switch (ast->adat.muveleti_jel) {
                    case '+':
                        return op1 + op2;
                    case '-':
                        return op1 - op2;
                    case '*':
                        return op1 * op2;
                    case '/':
                        return op1 / op2;
                }
        }

        return 0.0; //default ágak hiánya miatt
    }
}

bool kiertekel(char *szoveg, szimbolum **ast) {
    return osszeg(&szoveg, ast);
}
